<?php
/* -*- php -*- ****************************************************************
 *
 *  System        : 
 *  Module        : 
 *  Object Name   : $RCSfile$
 *  Revision      : $Revision$
 *  Date          : $Date$
 *  Author        : $Author$
 *  Created By    : Robert Heller
 *  Created       : Thu Oct 26 18:37:28 2017
 *  Last Modified : <171027.0836>
 *
 *  Description	
 *
 *  Notes
 *
 *  History
 *	
 ****************************************************************************
 *
 *    Copyright (C) 2017  Robert Heller D/B/A Deepwoods Software
 *			51 Locke Hill Road
 *			Wendell, MA 01379-9728
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * 
 *
 ****************************************************************************/

//require_once ( get_template_directory() . '/functions/DeepwoodsMetaBox.php' );
//require_once ( get_template_directory() . '/functions/deepsoft_paypal_ipn.php' );
require_once ( get_template_directory() . '/functions/navmenus.php' );
//require_once ( get_template_directory() . '/functions/deepsoft_comments.php' );

class CountryRobot_Theme {
  public static $TheThemeObject = null;
  
  var $options = null;
  private $ad_every_n_posts;
  
  function __construct ( $args = "" ) {
    add_action( 'after_setup_theme', array ($this, 'theme_setup') );
    add_action( 'wp_enqueue_scripts', array ($this, 'enqueue_scripts') );
    add_action( 'widgets_init' , array ($this, 'widgets_init'));
    add_action( 'admin_init', array ($this, 'options_init' ) );
    add_action( 'admin_menu', array ($this, 'options_add_page' ) );
    $this->ad_every_n_posts = array();
    $this->ad_every_n_posts['0'] = array('value' =>      '0',                                       
                                         'label' => __( 'Zero', 'country-robot' ) );
    $this->ad_every_n_posts['1'] = array('value' =>      '1',                                       
                                         'label' => __( 'One', 'country-robot' ) );
    $this->ad_every_n_posts['2'] = array('value' =>      '2',                                       
                                         'label' => __( 'Two', 'country-robot' ) );
    $this->ad_every_n_posts['3'] = array('value' =>      '3',                                       
                                         'label' => __( 'Three', 'country-robot' ) );
    $this->ad_every_n_posts['4'] = array('value' =>      '4',                                       
                                         'label' => __( 'Four', 'country-robot' ) );
    $this->ad_every_n_posts['5'] = array('value' =>      '5',                                       
                                         'label' => __( 'Five', 'country-robot' ) );
    
    CountryRobot_Theme::$TheThemeObject = $this;
  }
  
  function theme_setup () {
    add_theme_support( 'automatic-feed-links' );
    add_theme_support( 'title-tag' );
    $GLOBALS['content_width'] = 900;
    register_nav_menus( array(
                 'header-menu' => __('Header Menu', 'country-robot'),
                 'footer-menu' => __('Footer Menu', 'country-robot') ));
    wp_link_pages( );
    
  }
  function widgets_init () {
    if(function_exists('register_sidebar'))
    {
      register_sidebar(array('name'        => __('Right Sidebar','country-robot'),
                             'id'          => 'right-sidebar',
                             'description' => __('Right Sidebar widget area', 'country-robot')));
      register_sidebar(array('name'        => __('Left Sidebar', 'country-robot'),
                             'id'          => 'left-sidebar',
                             'description' => __('Left Sidebar widget area', 'country-robot')));
      register_sidebar(array('name'        => __('Page Bottom', 'country-robot'),
                             'id'          => 'page-bottom',
                             'description' => __('Page Bottom widget area', 'country-robot') ));
      register_sidebar(array('name'        => __('AdSense Leader', 'country-robot'),
                             'id'          => 'AdSenseLeader',
                             'description' => __('AdSense Leader','country-robot')));
      register_sidebar(array('name'        => __('AdSense Right', 'country-robot'),
                             'id'          => 'AdSenseRight',
                             'description' => __('AdSense Right','country-robot')) );
      register_sidebar(array('name'        => __('AdSense Interpost', 'country-robot'),
                             'id'          => 'AdSenseInterpost',
                             'description' => __('AdSense Interpost', 'country-robot')));
    }
    //@require_once ( get_template_directory() . '/functions/widgets.php' );
  }
  function enqueue_scripts() {
    wp_enqueue_style( 'country-robot-style', get_stylesheet_uri() );
    wp_enqueue_script( 'plusone', 'https://apis.google.com/js/plusone.js' );
  }
  
  function GetOption($optname) {
    if ($this->options == null) {
      $this->options = get_option('countryrobot_theme_options' );
    }
    return $this->options[$optname];
  }
  
  
  public static function postsPerAd () {
    
    if (CountryRobot_Theme::$TheThemeObject != null) {
      return CountryRobot_Theme::$TheThemeObject->GetOption('postsperad');
    } else {
      return 0;
    }
  }
  public static function enableLeft () {
    if (CountryRobot_Theme::$TheThemeObject != null) {
      return CountryRobot_Theme::$TheThemeObject->GetOption('enableleft');
    } else {
      return 0;
    }
  }
    
  public static function standard_page_menu ($args) {
    $defaults = array('container' => 'div',
                      'container_id' => 'navwrap',
                      'menu_class'     => 'flat_menu',
                      'menu_id'        => 'nav');
    $args = wp_parse_args( $args, $defaults );
    $args = apply_filters( 'wp_page_menu_args', $args );
    global $post;
    $homeLink = home_url() . '/';
    $homeTitle = "Home";
    $homepage = get_page_by_title("Home");
    $home_id = $homepage->ID;
    if ( is_page() || is_single() ) {
      $pageid = $post->ID;
      $name = get_the_title($post->ID);
      $parent = $post->post_parent;
    } else {
      $pageid = $home_id;
      $name = $homeTitle;
      $parent = 0;
    } 
    $menu = '';
    $menu .= '<li><a href="'.$homeLink.'" title="'.$homeTitle.'">'.$homeTitle.'</a></li>';
    $menu .= wp_list_categories( array ('title_li' => '',
                                        'depth' => 1,
                                        'include' => get_cat_ID('News'),
                                        'echo' => 0 ));
    $children = wp_list_pages( array ('title_li' => '',
                                      'depth' => 1,
                                      'sort_column' => 'menu_order',
                                      'child_of' => $pageid,
                                      'echo' => 0 ));
    if ( empty($children) ) {
      if ($parent != 0 && $parent != $home_id) {
        $parentbutton = $parent;
        $pageid = $parent;
      } else {
        $parentbutton = 0;
        $pageid = $home_id;
      }
    } elseif ($pageid != $home_id) {
      $parentbutton = $pageid;
    } else {
      $parentbutton = 0;
    }
    if ( $parentbutton != 0) {
      $menu .= wp_list_pages( array ('title_li' => '',
                                     'depth' => 1,
                                     'sort_column' => 'menu_order',
                                     'include' => $pageid,
                                     'echo' => 0 ));
    }
    $menu .= wp_list_pages( array ('title_li' => '',
                                   'depth' => 1,
                                   'sort_column' => 'menu_order',
                                   'exclude' => $home_id,
                                   'child_of' => $pageid,
                                   'echo' => 0 ));
    $bugreporturl = '';
    $bugreporturl = get_post_meta($pageid, 'bugreporturl', true);
    if (! empty($bugreporturl) ) {
      $menu .= '<li><a href="'.$bugreporturl.'">File a Bug</a></li>';
    }
    $consultPage = get_page_by_path('freeconsultation');
    $consult = $consultPage->ID;
    $menu .= wp_list_pages( array ('title_li' => '',
                                   'depth' => 1,
                                   'include' => $consult,
                                   'echo' => 0 ));
    $sitemapPage = get_page_by_path('sitemap');
    $sitemap = $sitemapPage->ID;
    $menu .= wp_list_pages( array ('title_li' => '',
                                   'depth' => 1,
                                   'include' => $sitemap,
                                   'echo' => 0 ));
    $menu .= wp_list_categories( array ('title_li' => '',
                                        'depth' => 1,
                                        'include' => get_cat_ID('Linux Articles'),
                                        'echo' => 0 ));
    $m1 = '<ul';
    if (! empty($args['menu_id']) ) {
      $m1 .= ' id="'.$args['menu_id'].'"';
    }
    if (! empty($args['menu_class']) ) {
      $m1 .= ' class="'.$args['menu_class'].'"';
    }
    $menu = $m1.'>'.$menu.'</ul>';
    if ($container) {
      $c1 = '<'.$container;
      if (! empty($args['container_id']) ) {
        $c1 .= ' id="'.$args['container_id'].'"';
      }
      if (! empty($args['container_class']) ) {
        $c1 .= ' class="'.$args['container_class'].'"';
      }
      $menu = $c1.'>'.$menu.'</'.$container.'>';
    }
    if ( $args['echo'] ) {
      echo $menu;
    } else {
      return $menu;
    }
  }

  function options_init() {
    register_setting('countryrobot_options',
                     'countryrobot_theme_options', 
                     array('sanitize_callback' => 
                           array($this, 'theme_options_validate')));
  }
  function theme_options_validate ( $input ) {
    /**** Validate... ****/
    if (!preg_match('/^(ca-)?pub-[0-9]+$/',$input['google_ad_client'])) {
      unset($input['google_ad_client']);
    }
    //Our checkbox value is either 0 or 1
    if ( ! isset( $input['enableleft'] ) ) $input['enableleft'] = null;
    $input['enableleft'] = ( $input['enableleft'] == 1 ? 1 : 0 );

    // Our checkbox value is either 0 or 1
    //if ( ! isset( $input['option1'] ) )
    //	$input['option1'] = null;
    //$input['option1'] = ( $input['option1'] == 1 ? 1 : 0 );
    //
    // Say our text option must be safe text with no HTML tags
    //$input['sometext'] = wp_filter_nohtml_kses( $input['sometext'] );
    //
    //Our select option must actually be in our array of select options
    if ( ! array_key_exists( $input['postsperad'], $this->ad_every_n_posts ) )
    $input['postsperad'] = 0;
	
    // Our radio option must actually be in our array of radio options
    //if ( ! isset( $input['radioinput'] ) )
    //	$input['radioinput'] = null;
    //if ( ! array_key_exists( $input['radioinput'], $radio_options ) )
    //	$input['radioinput'] = null;
    
    // Set default values for yes/no buttons.
    if ( ! isset( $input['headermenu'] ) ) $input['headermenu'] = 'yes';
    if ( ! isset( $input['footermenu'] ) ) $input['footermenu'] = 'yes';
    
    //
    // Say our textarea option must be safe text with the allowed tags for posts
    // $input['sometextarea'] = wp_filter_post_kses( $input['sometextarea'] );
    $input['custom_styles'] = wp_filter_post_kses( $input['custom_styles'] );
    return $input;
  }
  
  function options_add_page() {
    add_theme_page(__( 'Country Robot Options', 'country-robot' ),
                   __( 'Country Robot Options', 'country-robot' ),
                   'edit_theme_options', 
                   'theme_options', 
                   array($this, 'theme_options_do_page' ) );
  }

  function theme_options_do_page () {
    /**** Put up the theme options page ****/
    
    if ( ! isset( $_REQUEST['settings-updated'] ) )
      $_REQUEST['settings-updated'] = false;
    
    ?>
    <div class="wrap">
      <?php
        $theme = wp_get_theme();
        if ($theme == null) {
          $theme_name = "Country Robot";
        } else {
          $theme_name = $theme->Name;
        }
        echo "<h2>" . $theme_name . __( ' Theme Options', 'country-robot' ) . "</h2>"; ?>
      
      <?php if ( false !== $_REQUEST['settings-updated'] ) : ?>
      <div class="updated fade"><p><strong><?php _e( 'Options saved', 'country-robot' ); ?></strong></p></div>
      <?php endif; ?>
      
      <form method="post" action="options.php">
      <?php settings_fields( 'countryrobot_options' ); ?>
      <?php $options = get_option( 'countryrobot_theme_options' ); ?>
      
      
      <table class="form-table">
        
        <?php
          /**
            * A Country Robot checkbox option
            *  /
          ?>
          <tr valign="top"><th scope="row"><?php _e( 'A checkbox', 'country-robot' ); ?></th>
            <td>
              <input id="countryrobot_theme_options[option1]" name="countryrobot_theme_options[option1]" type="checkbox" value="1" <?php checked( '1', $options['option1'] ); ?> />
              <label class="description" for="countryrobot_theme_options[option1]"><?php _e( 'Country Robot checkbox', 'country-robot' ); ?></label>
            </td>
          </tr>
          */ ?>
         <?php
           /**
             * A Country Robot text input option
             *  /
           ?>
           <tr valign="top"><th scope="row"><?php _e( 'Some text', 'country-robot' ); ?></th>
             <td>
               <input id="countryrobot_theme_options[sometext]" class="regular-text" type="text" name="countryrobot_theme_options[sometext]" value="<?php esc_attr( $options['sometext'] ); ?>" />
               <label class="description" for="countryrobot_theme_options[sometext]"><?php _e( 'Country Robot text input', 'country-robot' ); ?></label>
             </td>
           </tr>
           */ ?>
          <?php
            /**
              * Enable Left Column?
              */
          ?>
          <tr valign="top"><th scope="row"><?php _e( 'Enable Left Column?', 'country-robot' ); ?></th>
            <td>
              <input id="countryrobot_theme_options[enableleft]" name="countryrobot_theme_options[enableleft]" type="checkbox" value="1" <?php checked( '1', $options['enableleft'] ); ?> />
              <label class="description" for="countryrobot_theme_options[option1]"><?php _e( 'Enable left sidebar', 'country-robot' ); ?></label>
            </td>
          </tr>
          <?php 
            /** 
              * Google Adsense client ID
              */
          ?>
          <tr valign="top"><th scope="row"><?php _e( 'Google Adsense Pub ID', 'country-robot' ); ?></th>
            <td>
              <input id="countryrobot_theme_options[google_ad_client]" class="regular-text" type="text" name="countryrobot_theme_options[google_ad_client]" value="<?php esc_attr( $options['google_ad_client'] ); ?>" />
              <label class="description" for="countryrobot_theme_options[google_ad_client]"><?php _e( 'Google Adsense Pub ID', 'country-robot' ); ?></label>
            </td>
          </tr>
          <?php
            $this->rbs(__('Google Adsense code type:',
                             'country-robot'),
                             array(__('Synchronous',
                                      'country-robot' ) 
                                      => 's',
                                      __('Asynchronous',
                                         'country-robot' ) 
                                      => 'a'),
                             'google_ad_type',
                             $options['google_ad_type'],
                             's');
            /**
              * A Country Robot select input option
              */
          ?>
          <tr valign="top"><th scope="row"><?php _e( 'Number of posts before an ad', 'country-robot' ); ?></th>
            <td>
              <select name="countryrobot_theme_options[postsperad]">
                <?php
                  $selected = $options['postsperad'];
                  $p = '';
                  $r = '';
                  
                  foreach ( $this->ad_every_n_posts as $option ) {
                    $label = $option['label'];
                    if ( $selected == $option['value'] ) // Make default first in list
                    $p = "\n\t<option style=\"padding-right: 10px;\" selected='selected' value='" . esc_attr( $option['value'] ) . "'>$label</option>";
                    else
                    $r .= "\n\t<option style=\"padding-right: 10px;\" value='" . esc_attr( $option['value'] ) . "'>$label</option>";
                  }
                  echo $p . $r;
                ?>
              </select>
              <label class="description" for="countryrobot_theme_options[postsperad]"><?php _e( 'Number of posts before an ad', 'country-robot' ); ?></label>
            </td>
          </tr>
          <?php
            /**
              * Navigation menu options
              */
            $this->yes_no_rbs(__('Header Menu','country-robot'),'headermenu',$options['headermenu']);
            $this->yes_no_rbs(__('Footer Menu','country-robot'),'footermenu',$options['footermenu']);
          ?>                              
          <?php
            /**
              * A Country Robot of radio buttons
              *  /
            ?>
            <tr valign="top"><th scope="row"><?php _e( 'Radio buttons', 'country-robot' ); ?></th>
              <td>
                <fieldset><legend class="screen-reader-text"><span><?php _e( 'Radio buttons', 'country-robot' ); ?></span></legend>
                <?php
                  if ( ! isset( $checked ) )
                  $checked = '';
                  foreach ( $radio_options as $option ) {
                    $radio_setting = $options['radioinput'];
                    
                    if ( '' != $radio_setting ) {
                      if ( $options['radioinput'] == $option['value'] ) {
                        $checked = "checked=\"checked\"";
                      } else {
                        $checked = '';
                      }
                    }
                  ?>
                  <label class="description"><input type="radio" name="countryrobot_theme_options[radioinput]" value="<?php esc_attr( $option['value'] ); ?>" <?php echo $checked; ?> /> <?php echo $option['label']; ?></label><br />
                  <?php
                  }
                ?>
                </fieldset>
              </td>
            </tr>
            */ ?>
           <?php
             /**
               * headerContent option
               */
           ?>
           <tr valign="top"><th scope="row"><?php _e( 'Header Content', 'country-robot' ); ?></th>
             <td>
               <textarea id="countryrobot_theme_options[headerContent]" class="large-text" cols="50" rows="10" name="countryrobot_theme_options[headerContent]"><?php echo esc_textarea( $options['headerContent'] ); ?></textarea>
               <label class="description" for="countryrobot_theme_options[headerContent]"><?php _e( 'meta tags, javascriptlets, etc.', 'country-robot' ); ?></label>
             </td>
           </tr>
           <?php
             /**
               * footerContent option
               */
           ?>
           <tr valign="top"><th scope="row"><?php _e( 'Footer Content', 'country-robot' ); ?></th>
             <td>
               <textarea id="countryrobot_theme_options[footerContent]" class="large-text" cols="50" rows="10" name="countryrobot_theme_options[footerContent]"><?php echo esc_textarea( $options['footerContent'] ); ?></textarea>
               <label class="description" for="countryrobot_theme_options[footerContent]"><?php _e( 'meta tags, javascriptlets, etc.', 'country-robot' ); ?></label>
             </td>
           </tr>
           <?php
             /**
               * Custom CSS option
               */
           ?>   
           <tr valign="top"><th scope="row"><?php _e( 'Custom CSS', 'country-robot' ); ?></th>
             <td>
               <textarea id="countryrobot_theme_options[custom_styles]" class="large-text" cols="50" rows="10" name="countryrobot_theme_options[custom_styles]"><?php echo esc_textarea( $options['custom_styles'] ); ?></textarea>
               <label class="description" for="countryrobot_theme_options[custom_styles]"><?php _e( 'Custom CSS', 'country-robot' ); ?></label>
             </td>
           </tr>
           <?php
             /**
               * Bottom Wide Content
               */
           ?>   
           <tr valign="top"><th scope="row"><?php _e( 'Wide Bottom Content', 'country-robot' ); ?></th>
             <td>
               <textarea id="countryrobot_theme_options[bottomwidecontent]" class="large-text" cols="50" rows="10" name="countryrobot_theme_options[bottomwidecontent]"><?php echo esc_textarea( $options['bottomwidecontent'] ); ?></textarea>
               <label class="description" for="countryrobot_theme_options[bottomwidecontent]"><?php _e( 'Wide Bottom Content', 'country-robot' ); ?></label>
             </td>
           </tr>
         </table>
         
         <p class="submit">
         <input type="submit" class="button-primary" value="<?php _e( 'Save Options', 'country-robot' ); ?>" />
         </p>
         </form>
       </div>
       <?php
  }

  function rbs($label,$lv_array,$optionname,$optionvalue,$default)
  {
    if ($optionvalue == '') $optionvalue = $default;
    
    ?><tr valign="top"><th scope="row"><?php echo $label; ?></th>
      <td>
        <fieldset><legend class="screen-reader-text"><span><?php echo $label; ?></span></legend>
        <?php
          if ( ! isset( $checked ) ) $checked = '';
          foreach ( $lv_array as $value_label => $value )
          {
            if ( '' != $optionvalue ) {
              if ( $optionvalue == $value ) 
              {
                $checked = "checked=\"checked\"";
              } else {
                $checked = '';
              }
            }
          ?>
          <label class="description"><input type="radio" name="countryrobot_theme_options[<?php echo $optionname; ?>]" value="<?php esc_attr( $value); ?>" <?php echo $checked; ?> /> <?php echo $value_label; ?></label><br />
          <?php
          }
        ?></fieldset></td>
    </tr><?php
  }
  function yes_no_rbs($label,$optionname,$optionvalue,$default = 'yes') {
    $yes_no = array('yes' => array('value' => 'yes',
                                   'label' => __( 'Yes', 'country-robot' ) ),
                    'no' => array('value' => 'no',
                                  'label' => __( 'No', 'country-robot' ) ));
    if ($optionvalue == '') $optionvalue = $default;
    ?><tr valign="top"><th scope="row"><?php echo $label; ?></th>
      <td>
        <fieldset><legend class="screen-reader-text"><span><?php echo $label; ?></span></legend>
        <?php
          if ( ! isset( $checked ) ) $checked = '';
          foreach ( $yes_no as $option ) {
            if ( '' != $optionvalue ) {
              if ( $optionvalue == $option['value'] ) {
                $checked = "checked=\"checked\"";
              } else {
                $checked = '';
              }
            }
          ?>
          <label class="description"><input type="radio" name="countryrobot_theme_options[<?php echo $optionname; ?>]" value="<?php esc_attr( $option['value'] ); ?>" <?php echo $checked; ?> /> <?php echo $option['label']; ?></label><br />
          <?php
          }
        ?>
        </fieldset>
      </td>
    </tr><?php
  }
  
  public static function breadcrumbs() {
    // Thanks to dimox for the code
    //http://dimox.net/wordpress-breadcrumbs-without-a-plugin/

    /* === OPTIONS === */
    $text['home']     = 'Home'; // text for the 'Home' link
    $text['category'] = '%s'; // text for a category page
    $text['search']   = 'Search Results for "%s" Query'; // text for a search results page
    $text['tag']      = 'Posts Tagged "%s"'; // text for a tag page
    $text['author']   = 'Articles Posted by %s'; // text for an author page
    $text['404']      = 'Error 404'; // text for the 404 page
    
    $showCurrent = 1; // 1 - show current post/page title in breadcrumbs, 0 - don't show
    $showOnHome  = 0; // 1 - show breadcrumbs on the homepage, 0 - don't show
    $delimiter   = ' &raquo; '; // delimiter between crumbs
    $before      = '<span class="current">'; // tag before the current crumb
    $after       = '</span>'; // tag after the current crumb
    /* === END OF OPTIONS === */
    
    global $post;
    $homeLink = home_url('/');
    $linkBefore = '<span typeof="v:Breadcrumb">';
    $linkAfter = '</span>';
    $linkAttr = ' rel="v:url" property="v:title"';
    $link = $linkBefore . '<a' . $linkAttr . ' href="%1$s">%2$s</a>' . $linkAfter;
    
    echo '<div id="crumbs">';
    
    if (is_home() || is_front_page()) {
      
      if ($showOnHome == 1) echo '<a href="' . $homeLink . '">' . $text['home'] . '</a>';
      
    } else {
      
      echo sprintf($link, $homeLink, $text['home']) . $delimiter;
      
      $homepage = get_page_by_title("Home"); 
      $home_id = $homepage->ID; 
      
      if ( is_category() ) {
        $thisCat = get_category(get_query_var('cat'), false);
        if ($thisCat->parent != 0) {
          $cats = get_category_parents($thisCat->parent, TRUE, $delimiter);
          $cats = str_replace('<a', $linkBefore . '<a' . $linkAttr, $cats);
          $cats = str_replace('</a>', '</a>' . $linkAfter, $cats);
          echo $cats;
        }
        echo $before . sprintf($text['category'], single_cat_title('', false)) . $after;
        
      } elseif ( is_search() ) {
        echo $before . sprintf($text['search'], get_search_query()) . $after;
        
      } elseif ( is_day() ) {
        echo sprintf($link, get_year_link(get_the_time('Y')), get_the_time('Y')) . $delimiter;
        echo sprintf($link, get_month_link(get_the_time('Y'),get_the_time('m')), get_the_time('F')) . $delimiter;
        echo $before . get_the_time('d') . $after;
        
      } elseif ( is_month() ) {
        echo sprintf($link, get_year_link(get_the_time('Y')), get_the_time('Y')) . $delimiter;
        echo $before . get_the_time('F') . $after;
        
      } elseif ( is_year() ) {
        echo $before . get_the_time('Y') . $after;
        
      } elseif ( is_single() && !is_attachment() ) {
        if ( get_post_type() != 'post' ) {
          $post_type = get_post_type_object(get_post_type());
          $slug = $post_type->rewrite;
          printf($link, $homeLink . '/' . $slug['slug'] . '/', $post_type->labels->singular_name);
          if ($showCurrent == 1) echo $delimiter . $before . get_the_title() . $after;
        } else {
          $cat = get_the_category(); $cat = $cat[0];
          $cats = get_category_parents($cat, TRUE, $delimiter);
          if ($showCurrent == 0) $cats = preg_replace("#^(.+)$delimiter$#", "$1", $cats);
          $cats = str_replace('<a', $linkBefore . '<a' . $linkAttr, $cats);
          $cats = str_replace('</a>', '</a>' . $linkAfter, $cats);
          echo $cats;
          if ($showCurrent == 1) echo $before . get_the_title() . $after;
        }
        
      } elseif ( !is_single() && !is_page() && get_post_type() != 'post' && !is_404() ) {
        $post_type = get_post_type_object(get_post_type());
        echo $before . $post_type->labels->singular_name . $after;
        
      } elseif ( is_attachment() ) {
        $parent = get_post($post->post_parent);
        $cat = get_the_category($parent->ID); 
        //file_put_contents("php://stderr","*** deepsoft_breadcrumbs(): cat = ".print_r($cat,true)."\n");
        $cat = $cat[0];
        //file_put_contents("php://stderr","*** deepsoft_breadcrumbs(): cat ([0]) = ".print_r($cat,true)."\n");
        if (!empty($cat)) {
          $cats = get_category_parents($cat, TRUE, $delimiter);
          $cats = str_replace('<a', $linkBefore . '<a' . $linkAttr, $cats);
          $cats = str_replace('</a>', '</a>' . $linkAfter, $cats);
          echo $cats;
        }
        printf($link, get_permalink($parent), $parent->post_title);
        if ($showCurrent == 1) echo $delimiter . $before . get_the_title() . $after;
        
      } elseif ( is_page() && !$post->post_parent ) {
        if ($showCurrent == 1) echo $before . get_the_title() . $after;
        
      } elseif ( is_page() && $post->post_parent ) {
        $parent_id  = $post->post_parent;
        $breadcrumbs = array();
        while ($parent_id) {
          $page = get_page($parent_id);
          if ($page->ID != $home_id) $breadcrumbs[] = sprintf($link, get_permalink($page->ID), get_the_title($page->ID));
          $parent_id  = $page->post_parent;
        }
        $breadcrumbs = array_reverse($breadcrumbs);
        echo "\n<!-- breadcrumbs: ";print_r($breadcrumbs);echo " -->\n";
        for ($i = 0; $i < count($breadcrumbs); $i++) {
          echo $breadcrumbs[$i];
          if ($i != count($breadcrumbs)-1) echo $delimiter;
        }
        if ($showCurrent == 1) {
          if (count($breadcrumbs) > 0) echo $delimiter;
          echo $before . get_the_title() . $after;
        }
        
      } elseif ( is_tag() ) {
        echo $before . sprintf($text['tag'], single_tag_title('', false)) . $after;
        
      } elseif ( is_author() ) {
        global $author;
        $userdata = get_userdata($author);
        echo $before . sprintf($text['author'], $userdata->display_name) . $after;
        
      } elseif ( is_404() ) {
        echo $before . $text['404'] . $after;
      }
      
      if ( get_query_var('paged') ) {
        if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ' (';
        echo __('Page', 'country-robot') . ' ' . get_query_var('paged');
        if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ')';
      }
      
    }
    echo '</div>';
  }
  public static function comment ( $comment, $args, $depth ) {
    file_put_contents("php://stderr","*** CountryRobot_Theme::comment(".print_r($comment,true).",".print_r($args,true)."','". $depth."')\n");
    $GLOBALS['comment'] = $comment;
    global $post;
    ?>
    <li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">
      <div id="comment-<?php comment_ID(); ?>">
        <?php if ( $comment->comment_type == '' ) { ?>
          <div class="avatar_cont"><?php echo get_avatar( $comment, '50' ); ?></div>
        <?php }
        if ( $comment->comment_type == '' ) {
          printf( __( 'Comment by %s', 'country-robot' ), '<em>' . get_comment_author_link() . '</em>' );
        } else {
          printf( __( 'Ping from %s', 'country-robot' ), '<em>' . get_comment_author_link() . '</em>' );
        }
        ?>:
        <?php if ( $comment->comment_approved == '0' ) { ?>				
          <em><?php _e( 'Your comment is awaiting moderation.', 'country-robot' ) ?></em>
        <?php } ?>
        <br />
        <small class="commentmetadata">
          <a href="#comment-<?php comment_ID() ?>" title=""><?php comment_date( 'l, F jS Y' ) ?> at <?php comment_time() ?></a>&nbsp;|&nbsp;<?php
          edit_comment_link( __( 'Edit', 'country-robot' ), '', '' );
          ?>
        </small>
        <?php comment_text(); ?>
        <div class="reply">
          <?php echo comment_reply_link( array( 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ); ?>
        </div>
      </div></li>
    <?php
  }
}



new CountryRobot_Theme();
